/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.smooth;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.collections.list.IntrusiveLinkedList;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherCombined;
import com.moulberry.axiom.pather.async.AsyncToolPatherMinSDF;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.smooth.ClosestBlockMap;
import com.moulberry.axiom.tools.smooth.WeightedPosition;
import com.moulberry.axiom.utils.GaussianBlurTable;
import com.moulberry.axiom.utils.NbtGetter;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class SmoothTool
implements Tool {
    private final ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
    private final Position2ObjectMap<WeightedPosition> positionMap = new Position2ObjectMap(k -> new WeightedPosition[4096]);
    private final IntrusiveLinkedList<WeightedPosition> sortedPositions = new IntrusiveLinkedList();
    private final IntrusiveLinkedList<WeightedPosition> newSortedPositions = new IntrusiveLinkedList();
    private int oldSolidCount = 0;
    private int blockCount = 0;
    private Position2FloatMap[] weights = null;
    private GaussianBlurTable[] blurTables = null;
    private ClosestBlockMap closestBlockMapSolid = null;
    private ClosestBlockMap closestBlockMapReplaceable = null;
    private AsyncToolPathProvider pathProvider = null;
    private boolean usingTool = false;
    private final BrushWidget brushWidget = new BrushWidget();
    private final float[] blurStddev = new float[]{2.0f};
    private final int[] blockRatio = new int[]{100};
    private int meltStableGrowMode = 1;
    private boolean fixEdges = true;
    private final PresetWidget presetWidget = new PresetWidget(this, "smooth");

    @Override
    public void reset() {
        if (this.usingTool) {
            this.usingTool = false;
            ChunkRenderOverrider.INSTANCE.release("smooth_tool");
        }
        this.blurTables = null;
        this.oldSolidCount = 0;
        this.blockCount = 0;
        this.blockRegion.clear();
        this.weights = null;
        this.positionMap.clear();
        this.sortedPositions.clear();
        this.closestBlockMapSolid = null;
        this.closestBlockMapReplaceable = null;
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                int i;
                int blurTableCount;
                this.reset();
                RayCaster.RaycastResult raycast = Tool.raycastBlock();
                if (raycast == null) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.blockRatio[0] <= 0) {
                    return UserAction.ActionResult.USED_STOP;
                }
                int n = blurTableCount = !this.fixEdges || (double)this.blurStddev[0] <= 1.5 ? 1 : (int)Math.ceil((this.blurStddev[0] - 1.0f) / 3.0f) + 1;
                if (blurTableCount <= 0) {
                    return UserAction.ActionResult.USED_STOP;
                }
                float blurStddevDelta = 0.0f;
                if (blurTableCount > 1) {
                    blurStddevDelta = (this.blurStddev[0] - 1.0f) / (float)(blurTableCount - 1);
                }
                this.blurTables = new GaussianBlurTable[blurTableCount];
                for (i = 0; i < blurTableCount; ++i) {
                    this.blurTables[i] = new GaussianBlurTable(this.blurStddev[0] - blurStddevDelta * (float)i, 0.01f);
                }
                if (this.blurTables[0].isSingleValued()) {
                    this.blurTables = null;
                    return UserAction.ActionResult.USED_STOP;
                }
                this.weights = new Position2FloatMap[blurTableCount];
                for (i = 0; i < blurTableCount; ++i) {
                    this.weights[i] = new Position2FloatMap();
                }
                if (!this.usingTool) {
                    this.usingTool = true;
                    ChunkRenderOverrider.INSTANCE.acquire("smooth_tool");
                }
                this.oldSolidCount = 0;
                this.blockCount = 0;
                this.blockRegion.clear();
                this.positionMap.clear();
                this.sortedPositions.clear();
                this.closestBlockMapSolid = new ClosestBlockMap(state -> !state.method_45474(), class_2246.field_10340.method_9564());
                this.closestBlockMapReplaceable = new ClosestBlockMap(blockState -> blockState.method_26215() || blockState.method_26204() == class_2246.field_10382 || blockState.method_26204() == class_2246.field_10164, class_2246.field_10124.method_9564());
                int additionalWeightRadius = this.blurTables[0].getTable().length / 2;
                BrushShape expanded = this.brushWidget.createBrushShapeWithAdditional(additionalWeightRadius);
                BrushShape brushShape = this.brushWidget.getBrushShape();
                if (this.blurTables.length == 1) {
                    this.pathProvider = new AsyncToolPathProvider(new AsyncToolPatherCombined(this.createSinglePatherForWeight(raycast.blockPos(), expanded), this.createSinglePatherForUpdate(brushShape)));
                    break;
                }
                this.pathProvider = new AsyncToolPathProvider(new AsyncToolPatherCombined(this.createMultiPatherForWeight(raycast.blockPos(), expanded), this.createMultiSmoothPather(brushShape)));
                break;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format(this.blockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.smoothed", countString);
            RegionHelper.pushBlockRegionChange(this.blockRegion, historyDescription, sourceInfo);
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.pathProvider.update();
            this.updateFromNewSortedPositions();
            this.newSortedPositions.clear();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.blockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        }
    }

    private AsyncToolPather createSinglePatherForWeight(class_2338 initialPosition, BrushShape weightShape) {
        final class_638 level = class_310.method_1551().field_1687;
        final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        final int initialX = initialPosition.method_10263();
        final int initialY = initialPosition.method_10264();
        final int initialZ = initialPosition.method_10260();
        final Position2FloatMap smoothedX = new Position2FloatMap();
        final Position2FloatMap smoothedZ = new Position2FloatMap();
        final Position2FloatMap weights = this.weights[0];
        final float[] table = this.blurTables[0].getTable();
        final int blurTableRadius = table.length / 2;
        return new AsyncToolPatherUnique(weightShape, null){

            @Override
            public void update() {
                long[] positions;
                smoothedX.clear();
                smoothedZ.clear();
                while ((positions = (long[])this.outputPositions.poll()) != null) {
                    for (long position : positions) {
                        int z2;
                        int y2;
                        int x2 = class_2338.method_10061((long)position);
                        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x2, y2 = class_2338.method_10071((long)position), z2 = class_2338.method_10083((long)position)));
                        if (blockState.method_45474()) continue;
                        int dx = initialX - x2;
                        int dy = initialY - y2;
                        int dz = initialZ - z2;
                        int distanceToInitialSq = dx * dx + dy * dy + dz * dz;
                        float factor = 1.0f - (float)Math.log(distanceToInitialSq + 10) * 0.001f;
                        for (int i = -blurTableRadius; i <= blurTableRadius; ++i) {
                            smoothedX.add(x2 + i, y2, z2, factor * table[i + blurTableRadius]);
                        }
                    }
                }
                smoothedX.forEachEntry((x, y, z, v) -> {
                    for (int i = -blurTableRadius; i <= blurTableRadius; ++i) {
                        smoothedZ.add(x, y, z + i, v * table[i + blurTableRadius]);
                    }
                });
                smoothedZ.forEachEntry((x, y, z, v) -> {
                    for (int i = -blurTableRadius; i <= blurTableRadius; ++i) {
                        weights.add(x, y + i, z, v * table[i + blurTableRadius]);
                    }
                });
            }
        };
    }

    private AsyncToolPather createMultiPatherForWeight(class_2338 initialPosition, BrushShape weightShape) {
        final class_638 level = class_310.method_1551().field_1687;
        final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        final int initialX = initialPosition.method_10263();
        final int initialY = initialPosition.method_10264();
        final int initialZ = initialPosition.method_10260();
        final Position2FloatMap[] smoothedXMaps = new Position2FloatMap[this.blurTables.length];
        final Position2FloatMap[] smoothedZMaps = new Position2FloatMap[this.blurTables.length];
        for (int i = 0; i < this.blurTables.length; ++i) {
            smoothedXMaps[i] = new Position2FloatMap();
            smoothedZMaps[i] = new Position2FloatMap();
        }
        return new AsyncToolPatherUnique(weightShape, null){

            @Override
            public void update() {
                long[] positions;
                for (Position2FloatMap map : smoothedXMaps) {
                    map.clear();
                }
                for (Position2FloatMap map : smoothedZMaps) {
                    map.clear();
                }
                while ((positions = (long[])this.outputPositions.poll()) != null) {
                    for (long position : positions) {
                        int z2;
                        int y2;
                        int x2 = class_2338.method_10061((long)position);
                        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x2, y2 = class_2338.method_10071((long)position), z2 = class_2338.method_10083((long)position)));
                        if (blockState.method_45474()) continue;
                        int dx = initialX - x2;
                        int dy = initialY - y2;
                        int dz = initialZ - z2;
                        int distanceToInitialSq = dx * dx + dy * dy + dz * dz;
                        float factor = 1.0f - (float)Math.log(distanceToInitialSq + 10) * 0.001f;
                        for (int i = 0; i < SmoothTool.this.blurTables.length; ++i) {
                            float[] anotherTable = SmoothTool.this.blurTables[i].getTable();
                            Position2FloatMap map = smoothedXMaps[i];
                            int anotherRadius = anotherTable.length / 2;
                            for (int j = -anotherRadius; j <= anotherRadius; ++j) {
                                map.add(x2 + j, y2, z2, factor * anotherTable[j + anotherRadius]);
                            }
                        }
                    }
                }
                for (int j = 0; j < SmoothTool.this.blurTables.length; ++j) {
                    float[] table = SmoothTool.this.blurTables[j].getTable();
                    Position2FloatMap weightOutput = SmoothTool.this.weights[j];
                    Position2FloatMap smoothedX = smoothedXMaps[j];
                    int radius = table.length / 2;
                    Position2FloatMap smoothedZ = new Position2FloatMap();
                    smoothedX.forEachEntry((x, y, z, v) -> {
                        for (int i = -radius; i <= radius; ++i) {
                            smoothedZ.add(x, y, z + i, v * table[i + radius]);
                        }
                    });
                    smoothedZ.forEachEntry((x, y, z, v) -> {
                        for (int i = -radius; i <= radius; ++i) {
                            weightOutput.add(x, y + i, z, v * table[i + radius]);
                        }
                    });
                }
            }
        };
    }

    private AsyncToolPather createSinglePatherForUpdate(BrushShape smoothShape) {
        class_638 level = class_310.method_1551().field_1687;
        MaskElement sourceMask = MaskManager.getSourceMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        Position2FloatMap weights = this.weights[0];
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        return new AsyncToolPatherUnique(smoothShape, (x, y, z) -> {
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (blockState.method_26204() == class_2246.field_10243) {
                return;
            }
            if (!blockState.method_26215() && !sourceMask.test(maskContext.reset(), x, y, z)) {
                return;
            }
            float weight = weights.get(x, y, z);
            this.newSortedPositions.add(new WeightedPosition(x, y, z, weight));
            if (!blockState.method_45474()) {
                ++this.blockCount;
            }
        });
    }

    private AsyncToolPather createMultiSmoothPather(BrushShape smoothShape) {
        final class_638 level = class_310.method_1551().field_1687;
        final MaskElement sourceMask = MaskManager.getSourceMask();
        final MaskContext maskContext = new MaskContext((class_1937)level);
        final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        final PositionSet addedThisUpdate = new PositionSet();
        final PositionSet finished = new PositionSet();
        final float blurStddev = this.blurStddev[0];
        final float blurStddevDeltaInv = (float)(this.blurTables.length - 1) / (this.blurStddev[0] - 1.0f);
        return new AsyncToolPatherMinSDF(smoothShape, null){

            @Override
            public void update() {
                int[] positions;
                addedThisUpdate.clear();
                while ((positions = (int[])this.outputData.poll()) != null) {
                    for (int i = 0; i < positions.length; i += 4) {
                        float weight;
                        int x = positions[i];
                        int y = positions[i + 1];
                        int z = positions[i + 2];
                        if (finished.contains(x, y, z)) continue;
                        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                        if (blockState.method_26204() == class_2246.field_10243) {
                            finished.add(x, y, z);
                            continue;
                        }
                        if (!blockState.method_26215() && !sourceMask.test(maskContext.reset(), x, y, z)) {
                            finished.add(x, y, z);
                            continue;
                        }
                        float distance = Float.intBitsToFloat(positions[i + 3]);
                        float falloff = 0.0f;
                        if ((double)distance > 0.6) {
                            falloff = (distance - 0.6f) / 0.4f;
                        } else {
                            finished.add(x, y, z);
                        }
                        if ((double)falloff < 0.01) {
                            weight = SmoothTool.this.weights[0].get(x, y, z);
                        } else {
                            float desiredStddev = blurStddev * (1.0f - falloff) + falloff;
                            float deltas = (blurStddev - desiredStddev) * blurStddevDeltaInv;
                            Position2FloatMap firstTable = SmoothTool.this.weights[(int)Math.floor(deltas)];
                            Position2FloatMap secondTable = SmoothTool.this.weights[(int)Math.ceil(deltas)];
                            float firstWeight = firstTable.get(x, y, z);
                            float secondWeight = secondTable.get(x, y, z);
                            float fpart = deltas - (float)Math.floor(deltas);
                            weight = firstWeight * (1.0f - fpart) + secondWeight * fpart;
                        }
                        WeightedPosition old = SmoothTool.this.positionMap.get(x, y, z);
                        if (old != null) {
                            old.weight = weight;
                            if (addedThisUpdate.contains(x, y, z)) continue;
                            SmoothTool.this.sortedPositions.remove(old);
                            if (old.solid) {
                                --SmoothTool.this.oldSolidCount;
                            }
                            SmoothTool.this.newSortedPositions.add(old);
                            addedThisUpdate.add(x, y, z);
                            continue;
                        }
                        WeightedPosition weightedPosition = new WeightedPosition(x, y, z, weight);
                        SmoothTool.this.newSortedPositions.add(weightedPosition);
                        addedThisUpdate.add(x, y, z);
                        SmoothTool.this.positionMap.put(x, y, z, weightedPosition);
                        if (blockState.method_45474()) continue;
                        ++SmoothTool.this.blockCount;
                    }
                }
            }
        };
    }

    private void updateFromNewSortedPositions() {
        if (this.newSortedPositions.isEmpty()) {
            return;
        }
        this.newSortedPositions.sort(Comparator.comparingDouble(w -> -w.weight));
        int solidCount = this.calculateBlockCount((float)this.blockRatio[0] / 100.0f, this.blockCount, this.sortedPositions.size() + this.newSortedPositions.size());
        Consumer<WeightedPosition> headSplit = e -> {
            class_2680 block = this.closestBlockMapSolid.get(e.x, e.y, e.z);
            this.blockRegion.addBlock(e.x, e.y, e.z, block);
            if (block.method_26216((class_1922)class_2682.field_12294, class_2338.field_10980) == e.renderOverrideWithAir) {
                if (e.renderOverrideWithAir) {
                    ChunkRenderOverrider.INSTANCE.revertBlock(e.x, e.y, e.z);
                    e.renderOverrideWithAir = false;
                } else {
                    ChunkRenderOverrider.INSTANCE.setBlock(e.x, e.y, e.z, class_2246.field_10124.method_9564());
                    e.renderOverrideWithAir = true;
                }
            }
            e.solid = true;
        };
        Consumer<WeightedPosition> tailSplit = e -> {
            class_2680 block = this.closestBlockMapReplaceable.get(e.x, e.y, e.z);
            this.blockRegion.addBlock(e.x, e.y, e.z, block);
            if (!e.renderOverrideWithAir) {
                ChunkRenderOverrider.INSTANCE.setBlock(e.x, e.y, e.z, class_2246.field_10124.method_9564());
                e.renderOverrideWithAir = true;
            }
            e.solid = false;
        };
        if (this.meltStableGrowMode == 0) {
            headSplit = e -> {
                e.solid = true;
            };
        }
        if (this.meltStableGrowMode == 2) {
            tailSplit = e -> {
                e.solid = false;
            };
        }
        this.sortedPositions.mergeSplitPosition(this.newSortedPositions, Comparator.comparingDouble(w -> -w.weight), this.oldSolidCount, solidCount, headSplit, tailSplit);
        this.oldSolidCount = solidCount;
    }

    private int calculateBlockCount(float ratio, int blockCount, int patherCount) {
        if (ratio <= 1.0f) {
            return (int)Math.ceil((float)blockCount * ratio);
        }
        float factor = ratio - 1.0f;
        if (factor > 1.0f) {
            factor = 1.0f;
        }
        return (int)Math.floor((float)blockCount * (1.0f - factor) + (float)patherCount * factor);
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean changed = this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.smoothing_options"));
        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.smooth.strength"), this.blurStddev, 0.75f, 10.0f, "%.2f", 32);
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.smooth.modifiers"));
        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.smooth.block_ratio"), this.blockRatio, 0, 200, "%d%%");
        int newMeltStableGrowMode = -1;
        if (this.meltStableGrowMode == 0) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.smooth.mode_melt"))) {
            newMeltStableGrowMode = 0;
        }
        if (this.meltStableGrowMode == 0) {
            ImGui.endDisabled();
        }
        ImGui.sameLine();
        if (this.meltStableGrowMode == 1) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.smooth.mode_stable"))) {
            newMeltStableGrowMode = 1;
        }
        if (this.meltStableGrowMode == 1) {
            ImGui.endDisabled();
        }
        ImGui.sameLine();
        if (this.meltStableGrowMode == 2) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.smooth.mode_grow"))) {
            newMeltStableGrowMode = 2;
        }
        if (this.meltStableGrowMode == 2) {
            ImGui.endDisabled();
        }
        if (newMeltStableGrowMode != -1) {
            this.meltStableGrowMode = newMeltStableGrowMode;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.advanced_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.smooth.fix_edges"), this.fixEdges)) {
            this.fixEdges = !this.fixEdges;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed);
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.smooth");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Smooth Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10548("SmoothStrength", this.blurStddev[0]);
        tag.method_10548("BlockRatio", (float)this.blockRatio[0] / 100.0f);
        tag.method_10567("MeltStableGrowMode", (byte)this.meltStableGrowMode);
        tag.method_10556("FixEdges", this.fixEdges);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.blurStddev[0] = NbtGetter.getFloatOrDefault(tag, "SmoothStrength", 2.0f);
        this.blockRatio[0] = Math.round(NbtGetter.getFloatOrDefault(tag, "BlockRatio", 1.0f) * 100.0f);
        this.meltStableGrowMode = NbtGetter.getIntOrDefault(tag, "MeltStableGrowMode", 1);
        this.fixEdges = NbtGetter.getBoolOrDefault(tag, "FixEdges", true);
    }

    @Override
    public char iconChar() {
        return '\ue905';
    }

    @Override
    public String keybindId() {
        return "smooth";
    }

    @Override
    public int defaultKeybind() {
        return 85;
    }
}

